<?php
/**
 * User Dashboard
 * GHAMECC Choir Management Platform
 */

// Include authentication functions
require_once '../includes/auth.php';

// Require login and user role
requireLogin();
requireRole('user');

// Get user information
$userId = $_SESSION['user_id'];
$userFullName = $_SESSION['full_name'] ?? $_SESSION['email'] ?? 'User';

// Set base path for includes
$basePath = '..';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Dashboard - GHAMECC Choir Management</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <?php include '../includes/navbar.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <?php include '../includes/sidebar.php'; ?>
            
            <!-- Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">User Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary">Share</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary">Export</button>
                        </div>
                    </div>
                </div>
                
                <!-- Welcome Card -->
                <div class="card shadow mb-4">
                    <div class="card-body">
                        <h4>Welcome to the User Dashboard</h4>
                        <p>As a user, you can view choir events and manage your basic profile information.</p>
                    </div>
                </div>
                
                <div class="row">
                    <!-- User Quick Links -->
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">User Quick Links</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <a href="../profile/view.php" class="btn btn-primary btn-block w-100">
                                            <i class="fas fa-user me-2"></i> My Profile
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../events/calendar.php" class="btn btn-secondary btn-block w-100">
                                            <i class="fas fa-calendar-alt me-2"></i> Event Calendar
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../profile/change-password.php" class="btn btn-info btn-block w-100">
                                            <i class="fas fa-key me-2"></i> Change Password
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="../help/index.php" class="btn btn-warning btn-block w-100">
                                            <i class="fas fa-question-circle me-2"></i> Help Center
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- User Information -->
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">My Information</h6>
                            </div>
                            <div class="card-body">
                                <div class="text-center mb-4">
                                    <?php if (isset($_SESSION['profile_image']) && !empty($_SESSION['profile_image'])): ?>
                                        <img src="../uploads/profiles/<?php echo $_SESSION['profile_image']; ?>" class="img-profile rounded-circle" style="width: 100px; height: 100px;">
                                    <?php else: ?>
                                        <img src="../assets/img/default-profile.png" class="img-profile rounded-circle" style="width: 100px; height: 100px;">
                                    <?php endif; ?>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-borderless">
                                        <tr>
                                            <th>Name:</th>
                                            <td><?php echo htmlspecialchars($userFullName); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Username:</th>
                                            <td><?php echo htmlspecialchars($_SESSION['email']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Role:</th>
                                            <td><?php echo htmlspecialchars($_SESSION['role']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Last Login:</th>
                                            <td><?php echo date('Y-m-d H:i:s'); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Upcoming Events -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Upcoming Choir Events</h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>Event</th>
                                        <th>Date</th>
                                        <th>Time</th>
                                        <th>Location</th>
                                        <th>Description</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Sample data - would be replaced with actual events data -->
                                    <tr>
                                        <td>Choir Practice</td>
                                        <td><?php echo date('Y-m-d', strtotime('+2 days')); ?></td>
                                        <td>6:00 PM</td>
                                        <td>Main Church</td>
                                        <td>Regular weekly practice</td>
                                    </tr>
                                    <tr>
                                        <td>Sunday Performance</td>
                                        <td><?php echo date('Y-m-d', strtotime('next Sunday')); ?></td>
                                        <td>9:00 AM</td>
                                        <td>Main Church</td>
                                        <td>Sunday service performance</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                <!-- Announcements -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Announcements</h6>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <h5>Welcome to GHAMECC Choir Management System</h5>
                            <p>Thank you for joining our platform. If you need any assistance, please contact the administrator.</p>
                            <small>Posted: <?php echo date('Y-m-d'); ?></small>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Custom scripts -->
    <script src="../assets/js/scripts.js"></script>
</body>
</html>
