<?php
/**
 * JavaScript Resource Check
 * GHAMECC Choir Management Platform
 */

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>JavaScript Resource Check</h1>";
echo "<p>This page tests if JavaScript resources are loading correctly.</p>";

// List of JavaScript resources to check
$jsResources = [
    'Bootstrap JS' => 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js',
    'jQuery' => 'https://code.jquery.com/jquery-3.6.0.min.js'
];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>JavaScript Resource Check</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .success { color: green; }
        .error { color: red; }
        .resource { margin-bottom: 10px; padding: 10px; border: 1px solid #ddd; }
    </style>
</head>
<body>
    <h2>Testing Resources:</h2>
    
    <div id="results">
        <?php foreach ($jsResources as $name => $url): ?>
        <div class="resource" id="<?php echo md5($url); ?>">
            <h3><?php echo htmlspecialchars($name); ?></h3>
            <p>URL: <?php echo htmlspecialchars($url); ?></p>
            <p>Status: <span class="status">Checking...</span></p>
        </div>
        <?php endforeach; ?>
    </div>
    
    <h2>Menu Collapse Test:</h2>
    <p>Click the button below to test if Bootstrap's collapse functionality works:</p>
    
    <button class="btn btn-primary" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTest" aria-expanded="false" aria-controls="collapseTest">
        Toggle Test Menu
    </button>
    
    <div class="collapse" id="collapseTest">
        <div class="card card-body" style="margin-top: 10px; background-color: #f8f9fa; padding: 15px;">
            If you can see this text after clicking the button, Bootstrap's collapse functionality is working correctly!
        </div>
    </div>
    
    <script>
        // Function to check if a script can be loaded
        function checkScript(url, elementId) {
            const script = document.createElement('script');
            script.src = url;
            
            script.onload = function() {
                document.querySelector('#' + elementId + ' .status').textContent = 'Loaded successfully';
                document.querySelector('#' + elementId + ' .status').className = 'status success';
            };
            
            script.onerror = function() {
                document.querySelector('#' + elementId + ' .status').textContent = 'Failed to load';
                document.querySelector('#' + elementId + ' .status').className = 'status error';
            };
            
            document.head.appendChild(script);
        }
        
        // Check each resource
        <?php foreach ($jsResources as $name => $url): ?>
        checkScript('<?php echo $url; ?>', '<?php echo md5($url); ?>');
        <?php endforeach; ?>
    </script>
    
    <!-- Load Bootstrap CSS for styling the test button -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Load Bootstrap JS at the end to test collapse functionality -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
