<?php
/**
 * My Applications - Job Portal
 * GHAMECC Job Portal
 */

require_once '../config/database.php';
require_once '../includes/auth.php';

// Check if user is logged in
if (!isLoggedIn()) {
    header('Location: login.php');
    exit();
}

$userId = $_SESSION['user_id'];

// Get user's job applications
$applications = fetchRows("
    SELECT ja.*, j.title, j.company_name, j.location, j.salary_range, 
           j.deadline, jc.name as category_name
    FROM job_applications ja
    JOIN jobs j ON ja.job_id = j.id
    LEFT JOIN job_categories jc ON j.category_id = jc.id
    WHERE ja.job_portal_user_id = ?
    ORDER BY ja.created_at DESC
", [$userId]);

$pageTitle = "My Applications";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - GHAMECC Job Portal</title>
    
    <?php include '../includes/favicon.php'; ?>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .application-card {
            transition: transform 0.2s;
        }
        .application-card:hover {
            transform: translateY(-2px);
        }
        .status-badge {
            font-size: 0.8rem;
        }
        .status-pending { background-color: #ffc107; }
        .status-shortlisted { background-color: #17a2b8; }
        .status-rejected { background-color: #dc3545; }
        .status-selected { background-color: #28a745; }
    </style>
</head>
<body>
    <?php include 'includes/job-portal-navbar.php'; ?>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-briefcase me-2"></i><?php echo $pageTitle; ?></h2>
                    <a href="job-listings.php" class="btn btn-primary">
                        <i class="fas fa-search me-2"></i>Browse Jobs
                    </a>
                </div>

                <?php if (empty($applications)): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <h4 class="text-muted">No Applications Yet</h4>
                        <p class="text-muted">You haven't applied to any jobs yet. Start browsing available opportunities!</p>
                        <a href="job-listings.php" class="btn btn-primary">
                            <i class="fas fa-search me-2"></i>Browse Jobs
                        </a>
                    </div>
                <?php else: ?>
                    <div class="row">
                        <?php foreach ($applications as $app): ?>
                            <div class="col-md-6 col-lg-4 mb-4">
                                <div class="card application-card h-100">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <h5 class="card-title"><?php echo htmlspecialchars($app['title']); ?></h5>
                                            <span class="badge status-badge status-<?php echo $app['status']; ?>">
                                                <?php echo ucfirst($app['status']); ?>
                                            </span>
                                        </div>
                                        
                                        <h6 class="card-subtitle mb-2 text-muted">
                                            <i class="fas fa-building me-1"></i>
                                            <?php echo htmlspecialchars($app['company_name']); ?>
                                        </h6>
                                        
                                        <div class="mb-2">
                                            <small class="text-muted">
                                                <i class="fas fa-map-marker-alt me-1"></i>
                                                <?php echo htmlspecialchars($app['location']); ?>
                                            </small>
                                        </div>
                                        
                                        <?php if ($app['category_name']): ?>
                                            <div class="mb-2">
                                                <span class="badge bg-secondary">
                                                    <?php echo htmlspecialchars($app['category_name']); ?>
                                                </span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if ($app['salary_range']): ?>
                                            <div class="mb-2">
                                                <small class="text-success">
                                                    <i class="fas fa-money-bill-wave me-1"></i>
                                                    <?php echo htmlspecialchars($app['salary_range']); ?>
                                                </small>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <div class="mb-3">
                                            <small class="text-muted">
                                                Applied: <?php echo date('M j, Y', strtotime($app['created_at'])); ?>
                                            </small>
                                        </div>
                                        
                                        <?php if ($app['cover_letter']): ?>
                                            <div class="mb-3">
                                                <small class="text-muted d-block">Cover Letter:</small>
                                                <small class="text-truncate d-block" style="max-height: 3em; overflow: hidden;">
                                                    <?php echo htmlspecialchars(substr($app['cover_letter'], 0, 100)) . (strlen($app['cover_letter']) > 100 ? '...' : ''); ?>
                                                </small>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="card-footer bg-transparent">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <small class="text-muted">
                                                Deadline: <?php echo date('M j, Y', strtotime($app['deadline'])); ?>
                                            </small>
                                            <a href="job-details.php?id=<?php echo $app['job_id']; ?>" class="btn btn-sm btn-outline-primary">
                                                View Job
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="mt-4 text-center">
                        <p class="text-muted">
                            Total Applications: <strong><?php echo count($applications); ?></strong>
                        </p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
