<?php
/**
 * AJAX Handler - Mark Notification as Read
 * GHAMECC Job Portal
 * 
 * This file handles AJAX requests to mark a notification as read
 */

// Include required files
require_once '../../config/database.php';
require_once '../../includes/functions.php';
require_once '../../includes/auth.php';
require_once '../../includes/notifications-library.php';

// Check if user is logged in
if (!isLoggedIn()) {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Get notification ID
$notificationId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($notificationId <= 0) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['success' => false, 'message' => 'Invalid notification ID']);
    exit;
}

// Get current user ID
$userId = $_SESSION['user_id'];

// Mark notification as read
$success = markNotificationAsRead($notificationId, $userId);

// Return response
header('Content-Type: application/json');
echo json_encode(['success' => $success]);
exit;
?>
