<?php
/**
 * AJAX Handler - Mark All Notifications as Read
 * GHAMECC Job Portal
 * 
 * This file handles AJAX requests to mark all notifications as read for the current user
 */

// Include required files
require_once '../../config/database.php';
require_once '../../includes/functions.php';
require_once '../../includes/auth.php';
require_once '../../includes/notifications-library.php';

// Check if user is logged in
if (!isLoggedIn()) {
    header('HTTP/1.1 401 Unauthorized');
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Get current user ID
$userId = $_SESSION['user_id'];

// Mark all notifications as read
$success = markAllNotificationsAsRead($userId);

// Return response
header('Content-Type: application/json');
echo json_encode(['success' => $success]);
exit;
?>
