<?php
/**
 * Sidebar Navigation Component
 * GHAMECC Choir Management Platform
 */

// Set default basePath if not already set
if (!isset($basePath)) {
    $basePath = '..';
}

// Get current page for active link highlighting
$currentPage = basename($_SERVER['PHP_SELF']);
$currentDir = dirname($_SERVER['PHP_SELF']);
$currentDir = str_replace('\\', '/', $currentDir);
$currentDir = explode('/', $currentDir);
$currentDir = end($currentDir);

// Function to check if a link should be active
function isActive($page, $dir = null) {
    global $currentPage, $currentDir;
    
    if ($dir !== null) {
        return $currentDir === $dir ? 'active' : '';
    }
    
    return $currentPage === $page ? 'active' : '';
}

// Function to check if a menu should be expanded
function isExpanded($dir) {
    global $currentDir;
    return $currentDir === $dir ? 'true' : 'false';
}

// Function to check if a menu should have the show class
function isShown($dir) {
    global $currentDir;
    return $currentDir === $dir ? 'show' : '';
}
?>

<nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo isActive('index.php'); ?>" href="<?php echo $basePath; ?>/index.php">
                    <i class="fas fa-tachometer-alt me-2"></i>
                    Dashboard
                </a>
            </li>
            
            <!-- Members Section -->
            <li class="nav-item">
                <a class="nav-link dropdown-toggle <?php echo $currentDir === 'members' ? 'active' : ''; ?>" 
                   href="#membersSubmenu" 
                   data-bs-toggle="collapse" 
                   aria-expanded="<?php echo isExpanded('members'); ?>" 
                   aria-controls="membersSubmenu">
                    <i class="fas fa-users me-2"></i>
                    Members
                </a>
                <div class="collapse <?php echo isShown('members'); ?>" id="membersSubmenu">
                    <ul class="nav flex-column ms-3">
                        <li class="nav-item">
                            <a class="nav-link <?php echo isActive('list.php', 'members'); ?>" href="<?php echo $basePath; ?>/members/list.php">
                                <i class="fas fa-list me-2"></i>
                                Member List
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo isActive('register.php', 'members'); ?>" href="<?php echo $basePath; ?>/members/register.php">
                                <i class="fas fa-user-plus me-2"></i>
                                Register Member
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo isActive('edit.php', 'members'); ?>" href="<?php echo $basePath; ?>/members/edit.php">
                                <i class="fas fa-user-edit me-2"></i>
                                Edit Member
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo isActive('view.php', 'members'); ?>" href="<?php echo $basePath; ?>/members/list.php">
                                <i class="fas fa-eye me-2"></i>
                                View Member
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            
            <!-- Conferences Section -->
            <li class="nav-item">
                <a class="nav-link dropdown-toggle <?php echo $currentDir === 'conferences' ? 'active' : ''; ?>" 
                   href="#conferencesSubmenu" 
                   data-bs-toggle="collapse" 
                   aria-expanded="<?php echo $currentDir === 'conferences' ? 'true' : 'false'; ?>" 
                   aria-controls="conferencesSubmenu">
                    <i class="fas fa-calendar-alt me-2"></i>
                    Conferences
                </a>
                <div class="collapse <?php echo $currentDir === 'conferences' ? 'show' : ''; ?>" id="conferencesSubmenu">
                    <ul class="nav flex-column ms-3">
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'index.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/index.php">
                                <i class="fas fa-list me-2"></i>
                                All Conferences
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'create.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/create.php">
                                <i class="fas fa-plus-circle me-2"></i>
                                Create Conference
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'diocese_setup.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/diocese_setup.php">
                                <i class="fas fa-church me-2"></i>
                                Diocese Conference Setup
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'circuit_setup.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/circuit_setup.php">
                                <i class="fas fa-building me-2"></i>
                                Circuit Conference Setup
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'diocese_delegates.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/diocese_delegates.php">
                                <i class="fas fa-users-cog me-2"></i>
                                Manage Diocese Delegates
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'diocese_sessions.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/diocese_sessions.php">
                                <i class="fas fa-calendar-day me-2"></i>
                                Manage Diocese Sessions
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'society_delegates.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/select_conference.php?target=society_delegates">
                                <i class="fas fa-user-friends me-2"></i>
                                Manage Society Delegates
                            </a>
                        </li>
                        
                        <?php if (hasRole(['circuit_chairman', 'circuit_secretary', 'circuit_treasurer', 'circuit_music_director'])): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'circuit_conference_delegates.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/select_conference.php?target=circuit_conference_delegates">
                                <i class="fas fa-users-cog me-2"></i>
                                View Circuit Delegates
                            </a>
                        </li>
                        <?php endif; ?>
                        
                        <?php if (hasRole(['diocesan_chairman', 'diocesan_secretary', 'diocesan_treasurer', 'diocesan_dom'])): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'diocese_conference_delegates.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/select_conference.php?target=diocese_conference_delegates">
                                <i class="fas fa-users-cog me-2"></i>
                                View Diocese Delegates
                            </a>
                        </li>
                        <?php endif; ?>
                        
                        <?php 
                        // Debug role information
                        $currentRole = isset($_SESSION['role']) ? $_SESSION['role'] : 'none';
                        $societyRoles = ['choirmaster', 'society_secretary', 'society_treasurer'];
                        $hasSocietyRole = in_array($currentRole, $societyRoles);
                        
                        if (hasRole(['choirmaster', 'society_secretary', 'society_treasurer'])): 
                        ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'society_diocese_delegates.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/society_diocese_delegates.php">
                                <i class="fas fa-users me-2"></i>
                                Register Members for Diocese Conference
                            </a>
                        </li>
                        <?php endif; ?>
                        
                        <?php if (hasRole(['diocesan_chairman', 'diocesan_secretary', 'diocesan_treasurer', 'diocesan_dom'])): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'delegate_accommodation.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/select_conference.php?target=delegate_accommodation">
                                <i class="fas fa-user-check me-2"></i>
                                Delegate Accommodation
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'accommodation_types.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/accommodation_types.php">
                                <i class="fas fa-building me-2"></i>
                                Accommodation Types
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'room_assignments.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/select_conference.php?target=room_assignments">
                                <i class="fas fa-door-open me-2"></i>
                                Room Assignments
                            </a>
                        </li>
                        <?php endif; ?>
                        
                        <li class="nav-item">
                            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'register.php' && $currentDir === 'conferences' ? 'active' : ''; ?>" href="<?php echo $basePath; ?>/conferences/register.php">
                                <i class="fas fa-user-plus me-2"></i>
                                Register for Conference
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            
            <!-- Jobs Section -->
            <li class="nav-item">
                <?php 
                // Determine the correct Jobs page based on user role
                $jobsPage = 'jobs/index.php';
                $jobsActiveCheck = 'jobs.php';
                
                if (isset($_SESSION['user_id']) && hasRole(['admin', 'society_secretary', 'choirmaster', 'diocesan_secretary', 'diocese_chairman'])) {
                    $jobsPage = 'job-approval.php';
                    $jobsActiveCheck = 'job-approval.php';
                }
                ?>
                <a class="nav-link <?php echo isActive($jobsActiveCheck); ?>" href="<?php echo $basePath; ?>/<?php echo $jobsPage; ?>">
                    <i class="fas fa-briefcase me-2"></i>
                    Jobs
                    <?php
                    // Show pending jobs count badge for authorized users
                    if (isset($_SESSION['user_id']) && hasRole(['admin', 'society_secretary', 'choirmaster', 'diocesan_secretary', 'diocese_chairman'])) {
                        $pendingJobsCount = 0;
                        if (isset($conn)) {
                            $countQuery = "SELECT COUNT(*) as count FROM jobs WHERE status = 'pending'";
                            
                            // Filter based on user permissions - diocese roles see all jobs
                            if (!hasRole(['admin', 'diocesan_secretary', 'diocese_chairman'])) {
                                if (isset($_SESSION['society_id']) && !empty($_SESSION['society_id'])) {
                                    $countQuery .= " AND society_id = " . (int)$_SESSION['society_id'];
                                } elseif (isset($_SESSION['circuit_id']) && !empty($_SESSION['circuit_id'])) {
                                    $countQuery .= " AND society_id IN (SELECT id FROM societies WHERE circuit_id = " . (int)$_SESSION['circuit_id'] . ")";
                                }
                            }
                            
                            $countResult = fetchRow($countQuery);
                            if ($countResult) {
                                $pendingJobsCount = (int)$countResult['count'];
                            }
                        }
                        
                        if ($pendingJobsCount > 0) {
                            echo '<span class="badge bg-warning text-dark ms-1">' . $pendingJobsCount . '</span>';
                        }
                    }
                    ?>
                </a>
            </li>
            
            <!-- Adverts Section (Diocese + Connexion roles only) -->
            <?php if (hasRole(['admin', 'diocesan_chairman', 'diocese_chairman', 'diocesan_secretary', 'diocesan_treasurer', 'diocesan_dom', 'diocesan_music_director'])): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo isActive('submit.php', 'ads'); ?>" href="<?php echo $basePath; ?>/ads/submit.php">
                    <i class="fas fa-bullhorn me-2"></i>
                    Adverts
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo isActive('my-ads.php', 'ads'); ?>" href="<?php echo $basePath; ?>/ads/my-ads.php">
                    <i class="fas fa-clipboard-list me-2"></i>
                    My Adverts
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo isActive('manage.php', 'ads'); ?>" href="<?php echo $basePath; ?>/ads/manage.php">
                    <i class="fas fa-check-circle me-2"></i>
                    Manage Adverts
                </a>
            </li>
            <?php if (hasRole(['admin', 'diocesan_chairman', 'diocese_chairman', 'diocesan_secretary', 'diocesan_treasurer', 'diocesan_dom', 'diocesan_music_director'])): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo isActive('categories.php', 'ads'); ?>" href="<?php echo $basePath; ?>/ads/categories.php">
                    <i class="fas fa-tags me-2"></i>
                    Ad Categories
                </a>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            
            <!-- Attendance Section -->
            <li class="nav-item">
                <a class="nav-link <?php echo isActive('attendance.php'); ?>" href="<?php echo $basePath; ?>/attendance/index.php">
                    <i class="fas fa-clipboard-check me-2"></i>
                    Attendance
                </a>
            </li>
            
            <!-- Finance Section -->
            <li class="nav-item">
                <a class="nav-link <?php echo isActive('finance.php'); ?>" href="<?php echo $basePath; ?>/finance/index.php">
                    <i class="fas fa-money-bill-wave me-2"></i>
                    Finance
                </a>
            </li>
            
            <!-- Reports Section -->
            <li class="nav-item">
                <a class="nav-link dropdown-toggle <?php echo $currentDir === 'reports' ? 'active' : ''; ?>" 
                   href="#reportsSubmenu" 
                   data-bs-toggle="collapse" 
                   aria-expanded="<?php echo isExpanded('reports'); ?>" 
                   aria-controls="reportsSubmenu">
                    <i class="fas fa-file-alt me-2"></i>
                    Reports
                </a>
                <div class="collapse <?php echo isShown('reports'); ?>" id="reportsSubmenu">
                    <ul class="nav flex-column ms-3">
                        <li class="nav-item">
                            <a class="nav-link <?php echo isActive('submit.php', 'reports'); ?>" href="<?php echo $basePath; ?>/reports/submit.php">
                                <i class="fas fa-paper-plane me-2"></i>
                                Submit Report
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo isActive('received.php', 'reports'); ?>" href="<?php echo $basePath; ?>/reports/received.php">
                                <i class="fas fa-inbox me-2"></i>
                                Received Reports
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo isActive('sent.php', 'reports'); ?>" href="<?php echo $basePath; ?>/reports/sent.php">
                                <i class="fas fa-share-square me-2"></i>
                                Sent Reports
                            </a>
                        </li>
                        <!-- Circuit Report Consolidation - Only for circuit-level users -->
                        <?php if (hasRole(['circuit_chairman', 'circuit_secretary', 'circuit_dom', 'circuit_treasurer'])): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo isActive('circuit_consolidation.php', 'reports'); ?>" href="<?php echo $basePath; ?>/reports/circuit_consolidation.php">
                                <i class="fas fa-compress-alt me-2"></i>
                                Circuit Consolidation
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            
            <!-- Song Sheets Section -->
            <li class="nav-item">
                <a class="nav-link <?php echo isActive('index.php', 'songs'); ?>" href="<?php echo $basePath; ?>/songs/index.php">
                    <i class="fas fa-music me-2"></i>
                    Song Sheets
                </a>
            </li>
            
            <!-- Admin Section -->
            <?php if (hasRole(['admin', 'diocesan_chairman', 'diocesan_secretary', 'diocesan_dom', 'diocesan_treasurer', 'circuit_chairman', 'circuit_secretary', 'circuit_dom', 'circuit_treasurer'])): ?>
            <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                <span>Administration</span>
            </h6>
            <ul class="nav flex-column mb-2">
                <?php if (hasRole(['admin'])): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo isActive('dioceses.php', 'admin'); ?>" href="<?php echo $basePath; ?>/admin/dioceses.php">
                        <i class="fas fa-church me-2"></i>
                        Dioceses
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (hasRole(['admin', 'diocesan_chairman', 'diocesan_secretary', 'diocesan_dom', 'diocesan_treasurer'])): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo isActive('circuits.php', 'admin'); ?>" href="<?php echo $basePath; ?>/circuits/index.php">
                        <i class="fas fa-sitemap me-2"></i>
                        Circuits
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (hasRole(['admin', 'diocesan_chairman', 'diocesan_secretary', 'diocesan_music_director', 'diocesan_treasurer', 'circuit_chairman', 'circuit_secretary', 'circuit_music_director', 'circuit_treasurer'])): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo isActive('societies.php', 'admin'); ?>" href="<?php echo $basePath; ?>/societies/index.php">
                        <i class="fas fa-users me-2"></i>
                        Societies
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (hasRole(['admin', 'diocesan_chairman', 'diocesan_secretary', 'diocesan_music_director', 'diocesan_treasurer', 'circuit_chairman', 'circuit_secretary', 'circuit_music_director', 'circuit_treasurer', 'society_secretary', 'society_treasurer', 'choirmaster'])): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo isActive('users.php', 'admin'); ?>" href="<?php echo $basePath; ?>/admin/users.php">
                        <i class="fas fa-user-cog me-2"></i>
                        Users Management
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (hasRole(['admin'])): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo isActive('settings.php', 'admin'); ?>" href="<?php echo $basePath; ?>/admin/settings.php">
                        <i class="fas fa-cogs me-2"></i>
                        Settings
                    </a>
                </li>
                <?php endif; ?>
            </ul>
            <?php endif; ?>
            
            <!-- User Account Section -->
            <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                <span>Account</span>
            </h6>
            <ul class="nav flex-column mb-2">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo $basePath; ?>/profile.php">
                        <i class="fas fa-user-circle me-2"></i>
                        My Profile
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo $basePath; ?>/logout.php">
                        <i class="fas fa-sign-out-alt me-2"></i>
                        Logout
                    </a>
                </li>
            </ul>
        </div>
    </nav>

<!-- Add this script at the end of the sidebar to ensure Bootstrap collapse works -->
<script>
    // Initialize Bootstrap collapse functionality manually if needed
    document.addEventListener('DOMContentLoaded', function() {
        // Check if Bootstrap is loaded
        if (typeof bootstrap === 'undefined') {
            console.error('Bootstrap JavaScript is not loaded. Loading local fallback...');
            
            // Simple toggle function for collapse elements as fallback
            document.querySelectorAll('[data-bs-toggle="collapse"]').forEach(function(element) {
                element.addEventListener('click', function(e) {
                    e.preventDefault();
                    var target = document.querySelector(this.getAttribute('data-bs-target') || this.getAttribute('href'));
                    if (target) {
                        if (target.classList.contains('show')) {
                            target.classList.remove('show');
                            this.setAttribute('aria-expanded', 'false');
                        } else {
                            target.classList.add('show');
                            this.setAttribute('aria-expanded', 'true');
                        }
                    }
                });
            });
        } else {
            console.log('Bootstrap JavaScript is loaded correctly.');
        }
    });
</script>
