<?php
// Include database connection
require_once '../config/database.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Check if user is logged in and has admin privileges
if (!isLoggedIn() || !hasPermission('admin')) {
    header('Location: ../login.php');
    exit;
}

// Function to execute SQL from file
function executeSQLFile($conn, $file) {
    $success = true;
    $error = '';
    
    try {
        // Read the SQL file
        $sql = file_get_contents($file);
        
        // Execute multi query
        if ($conn->multi_query($sql)) {
            // Process all result sets
            do {
                // Store result
                if ($result = $conn->store_result()) {
                    $result->free();
                }
            } while ($conn->more_results() && $conn->next_result());
        }
        
        // Check for errors
        if ($conn->error) {
            $success = false;
            $error = $conn->error;
        }
    } catch (Exception $e) {
        $success = false;
        $error = $e->getMessage();
    }
    
    return ['success' => $success, 'error' => $error];
}

// Path to SQL file
$sqlFile = __DIR__ . '/accommodation_schema.sql';

// Execute SQL file
$result = executeSQLFile($conn, $sqlFile);

// Display result
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Setup Accommodation Tables</title>
    
    <?php include '../includes/favicon.php'; ?>
    
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-header">
                        <h4>Database Setup - Accommodation Tables</h4>
                    </div>
                    <div class="card-body">
                        <?php if ($result['success']): ?>
                            <div class="alert alert-success">
                                <h5>Success!</h5>
                                <p>The accommodation tables have been successfully created in the database.</p>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-danger">
                                <h5>Error!</h5>
                                <p>There was an error creating the accommodation tables:</p>
                                <pre><?php echo $result['error']; ?></pre>
                            </div>
                        <?php endif; ?>
                        
                        <a href="../index.php" class="btn btn-primary">Return to Dashboard</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="../assets/js/jquery.min.js"></script>
    <script src="../assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>
