<?php
/**
 * Environment Configuration
 * GHAMECC Choir Management Platform
 * 
 * This file detects the current environment (local or production)
 * and sets the appropriate database credentials.
 */

// Define environments
define('ENV_LOCAL', 'local');
define('ENV_PRODUCTION', 'production');

// Detect environment based on server name or other indicators
function detectEnvironment() {
    // Check if running on cPanel (common cPanel server signatures)
    if (
        strpos($_SERVER['SERVER_SOFTWARE'] ?? '', 'cPanel') !== false ||
        strpos($_SERVER['HTTP_HOST'] ?? '', 'superbsystemstechnologies.com') !== false ||
        file_exists('/usr/local/cpanel') // Common cPanel installation directory
    ) {
        return ENV_PRODUCTION;
    }
    
    // Default to local environment
    return ENV_LOCAL;
}

// Get current environment
$currentEnv = detectEnvironment();

// Set database credentials based on environment
if ($currentEnv === ENV_PRODUCTION) {
    // Production (cPanel) database credentials - updated with actual values from debug output
    $host = 'localhost'; // Usually remains localhost on cPanel
    $username = 'edusys_mbmmobs'; // Actual cPanel database username
    $password = 'mbmmobs1!'; // Replace with the actual password you use
    $database = 'edusys_ghamecc'; // Actual cPanel database name
} else {
    // Local development database credentials
    $host = 'localhost';
    $username = 'root';
    $password = 'pass';
    $database = 'ghamecc';
}

// Log the environment for debugging (optional)
if (function_exists('logInfo')) {
    logInfo("Environment detected", ['environment' => $currentEnv]);
}
