<?php
require_once 'config/database.php';

header('Content-Type: text/plain');

echo "=== ATTACHMENTS DIAGNOSTIC ===\n\n";

try {
    // Check if application_media table exists
    $result = $conn->query("SHOW TABLES LIKE 'application_media'");
    if ($result->num_rows > 0) {
        echo "✅ application_media table EXISTS\n\n";
        
        // Show structure
        $structure = $conn->query("DESCRIBE application_media");
        echo "TABLE STRUCTURE:\n";
        while ($row = $structure->fetch_assoc()) {
            echo "- {$row['Field']}: {$row['Type']}\n";
        }
        
        // Count records
        $count = $conn->query("SELECT COUNT(*) as total FROM application_media");
        $total = $count->fetch_assoc()['total'];
        echo "\nTOTAL RECORDS: $total\n";
        
        if ($total > 0) {
            echo "\nSAMPLE DATA:\n";
            $sample = $conn->query("SELECT * FROM application_media LIMIT 3");
            while ($row = $sample->fetch_assoc()) {
                echo "ID: {$row['id']}, App: {$row['application_id']}, File: {$row['file_name']}\n";
            }
        }
        
    } else {
        echo "❌ application_media table DOES NOT EXIST\n\n";
        
        // Check for similar tables
        $tables = $conn->query("SHOW TABLES");
        echo "AVAILABLE TABLES:\n";
        while ($row = $tables->fetch_array()) {
            $table = $row[0];
            if (strpos($table, 'media') !== false || strpos($table, 'application') !== false) {
                echo "- $table\n";
            }
        }
    }
    
    // Check job_applications
    echo "\n=== JOB APPLICATIONS ===\n";
    $appCount = $conn->query("SELECT COUNT(*) as total FROM job_applications");
    $appTotal = $appCount->fetch_assoc()['total'];
    echo "Total applications: $appTotal\n";
    
    if ($appTotal > 0) {
        $sampleApp = $conn->query("SELECT id, job_id FROM job_applications LIMIT 1");
        $app = $sampleApp->fetch_assoc();
        echo "Sample application ID: {$app['id']}\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
