<?php
/**
 * AJAX handler to fetch circuits based on diocese ID
 * GHAMECC Choir Management Platform
 */

// Include database configuration
require_once '../config/database.php';

// Set content type to JSON
header('Content-Type: application/json');

// Check if diocese_id is provided
if (!isset($_GET['diocese_id']) || empty($_GET['diocese_id'])) {
    echo json_encode([]);
    exit;
}

// Get diocese ID
$dioceseId = (int)$_GET['diocese_id'];

// Fetch circuits for the selected diocese
$circuits = fetchRows(
    "SELECT id, name FROM circuits WHERE diocese_id = ? ORDER BY name",
    [$dioceseId]
);

// Return circuits as JSON
echo json_encode($circuits);
